<?php

// Cyb - web uploading
// http://www.disk4arab.com/ 
// Copyright 2006 uploading

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');

$vbulletin->input->clean_array_gpc('r', array(
	'cfruleid' => TYPE_INT
));

print_cp_header($vbphrase['uploading_mgr']);

// No Action
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'manage';
}

// Add Forum Rule
if ($_REQUEST['do'] == 'add')
{

	print_form_header('uploadingadmin', 'insert');

	print_table_header($vbphrase['cfrule_add_new']);
	print_input_row($vbphrase['cfrnumber'], 'cfrnumber');
	print_textarea_row($vbphrase['cfrule'], 'cfrule');
	print_input_row($vbphrase['cfrinfo'], 'cfrinfo');

	print_submit_row($vbphrase['save']);
}

// Insert Forum Rule
if ($_POST['do'] == 'insert')
{

	$vbulletin->input->clean_array_gpc('p', array(
		'cfrnumber'    => TYPE_STR,
		'cfrinfo'    => TYPE_STR,
		'cfrule' => TYPE_STR
	));

	if (empty($vbulletin->GPC['cfrnumber']) or empty($vbulletin->GPC['cfrule']))
	{
		print_stop_message('cfrule_invalid_specified');
	}

	/*insert query*/
	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "uploading
			(cfrulenumber, cfruledata, cfruleinfo)
		VALUES
			('" . $db->escape_string($vbulletin->GPC['cfrnumber']) . "', '" . $db->escape_string($vbulletin->GPC['cfrule']) . "', '" . $db->escape_string($vbulletin->GPC['cfrinfo']) . "')
	");

	define('CP_REDIRECT', 'uploadingadmin.php?do=manage');
	print_stop_message('cfrule_x_saved_ok', $vbulletin->GPC['cfrname']);
}

// Edit Forum Rule
if ($_REQUEST['do'] == 'edit')
{

	$cfrule = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "uploading WHERE cfruleid = " . $vbulletin->GPC['cfruleid']);

	print_form_header('uploadingadmin', 'doupdate');
	construct_hidden_code('cfruleid', $vbulletin->GPC['cfruleid']);

	print_input_row($vbphrase['cfrnumber'], 'cfrnumber', $cfrule['cfrulenumber']);
	print_textarea_row($vbphrase['cfrule'], 'cfrule', $cfrule['cfruledata']);
	print_input_row($vbphrase['cfrinfo'], 'cfrinfo', $cfrule['cfruleinfo']);
	
	print_submit_row($vbphrase['save']);

}

// Update Forum Rule
if ($_POST['do'] == 'doupdate')
{

	$vbulletin->input->clean_array_gpc('p', array(
		'cfrnumber'    => TYPE_STR,
		'cfrule' => TYPE_STR,
		'cfrinfo'    => TYPE_STR
	));

	if (empty($vbulletin->GPC['cfrnumber']) or empty($vbulletin->GPC['cfrule']))
	{
		print_stop_message('cfrule_invalid_specified');
	}

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "uploading
		SET cfrulenumber = '" . $db->escape_string($vbulletin->GPC['cfrnumber']) . "',
		cfruledata = '" . $db->escape_string($vbulletin->GPC['cfrule']) . "',
		cfruleinfo = '" . $db->escape_string($vbulletin->GPC['cfrinfo']) . "'
		WHERE cfruleid = " . $vbulletin->GPC['cfruleid'] . "
	");

	define('CP_REDIRECT', 'uploadingadmin.php?do=manage');
	print_stop_message('cfrule_x_saved_ok', $vbulletin->GPC['cfrnumber']);

}

// Confirm Forum Rule Delete
if ($_REQUEST['do'] == 'remove')
{

	print_form_header('uploadingadmin', 'kill');
	construct_hidden_code('cfruleid', $vbulletin->GPC['cfruleid']);
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row($vbphrase['cfrule_sure_delete']);
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);

}

// Delete Forum Rule
if ($_POST['do'] == 'kill')
{

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "uploading WHERE cfruleid = " . $vbulletin->GPC['cfruleid']);

	define('CP_REDIRECT', 'uploadingadmin.php?do=manage');
	print_stop_message('cfrule_deleted_ok');
}

// Manage Forum Rule
if ($_REQUEST['do'] == 'manage')
{
	$uploading = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "uploading
		ORDER BY cfruleid
	");

	?>
	<script type="text/javascript">
	function js_usergroup_jump(cfruleid, obj)
	{
		task = obj.options[obj.selectedIndex].value;
		switch (task)
		{
			case 'edit': window.location = "uploadingadmin.php?<?php echo $vbulletin->session->vars['sessionurl_js']; ?>do=edit&cfruleid=" + cfruleid; break;
			case 'kill': window.location = "uploadingadmin.php?<?php echo $vbulletin->session->vars['sessionurl_js']; ?>do=remove&cfruleid=" + cfruleid; break;
			default: return false; break;
		}
	}
	</script>
	<?php

	$options = array('edit' => $vbphrase['edit'], 'kill' => $vbphrase['delete']);

	print_form_header('uploadingadmin', 'add');
	print_table_header($vbphrase['uploading_mgr'], 4);

	print_cells_row(array($vbphrase['cfrnumber'], $vbphrase['cfrule'], $vbphrase['cfrinfo'], $vbphrase['controls']), 1);

	while ($cfrule = $db->fetch_array($uploading))
	{
		print_cells_row(array(
			'<b>' . $cfrule['cfrulenumber'] . '</b>',
			$cfrule['cfruledata'],
			$cfrule['cfruleinfo'],
			"\n\t<select name=\"u$cfrule[cfruleid]\" onchange=\"js_usergroup_jump($cfrule[cfruleid], this);\" class=\"bginput\">\n" . construct_select_options($options) . "\t</select>\n\t<input type=\"button\" value=\"" . $vbphrase['go'] . "\" onclick=\"js_usergroup_jump($cfrule[cfruleid], this.form.u$cfrule[cfruleid]);\" />\n\t"
		));
	}

	print_submit_row($vbphrase['cfrule_add_new'], 0, 4);

}

print_cp_footer();

?>